<?php

require __DIR__ . '/../../vendor/autoload.php';
$app = require_once __DIR__ . '/../../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing direct SQL INSERT with PostgreSQL triggers...\n\n";

// Test 1: Direct SQL INSERT
echo "Test 1: Direct SQL INSERT with approved=true\n";
DB::statement("INSERT INTO completions (service_id, user_id, charged, approved, date, created_at) VALUES (1, 1, 150, true, now(), now())");
$lastId = DB::getPdo()->lastInsertId();
echo "Inserted completion ID: $lastId\n";

$commission = DB::table('commissions')->where('completions_id', $lastId)->first();
if ($commission) {
    echo "✅ Commission created by trigger: ID {$commission->commission_id}, Amount: \${$commission->commission_amount}\n";
} else {
    echo "❌ No commission created\n";
}

echo "\n";

// Test 2: Direct SQL UPDATE to unapprove
echo "Test 2: Direct SQL UPDATE approved=false\n";
DB::statement("UPDATE completions SET approved = false WHERE completions_id = ?", [$lastId]);
$commissionAfter = DB::table('commissions')->where('completions_id', $lastId)->first();
if (!$commissionAfter) {
    echo "✅ Commission deleted by trigger\n";
} else {
    echo "❌ Commission still exists: ID {$commissionAfter->commission_id}\n";
}

echo "\n";

// Test 3: Direct SQL UPDATE to approve again
echo "Test 3: Direct SQL UPDATE approved=true again\n";
DB::statement("UPDATE completions SET approved = true WHERE completions_id = ?", [$lastId]);
$commissionNew = DB::table('commissions')->where('completions_id', $lastId)->first();
if ($commissionNew) {
    echo "✅ Commission re-created by trigger: ID {$commissionNew->commission_id}, Amount: \${$commissionNew->commission_amount}\n";
} else {
    echo "❌ No commission created\n";
}

echo "\n";

// Test 4: Direct SQL UPDATE charged amount
echo "Test 4: Direct SQL UPDATE charged amount (150 → 300)\n";
$oldAmount = $commissionNew->commission_amount;
echo "Old commission amount: \$$oldAmount\n";
DB::statement("UPDATE completions SET charged = 300 WHERE completions_id = ?", [$lastId]);
$commissionUpdated = DB::table('commissions')->where('completions_id', $lastId)->first();
if ($commissionUpdated && $commissionUpdated->commission_amount != $oldAmount) {
    echo "✅ Commission updated by trigger: \${$commissionUpdated->commission_amount}\n";
} else {
    echo "❌ Commission not updated\n";
}

echo "\n";

// Cleanup
echo "Cleaning up test data...\n";
DB::statement("DELETE FROM completions WHERE completions_id = ?", [$lastId]);
echo "✅ Done!\n";
