<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;

Route::get('/', function () {
    return view('welcome');
});

// Shop & Products
Route::get('/shop', [ProductController::class, 'index'])->name('shop');
Route::get('/category/{category}', [ProductController::class, 'category'])->name('category');
Route::get('/brand/{brand}', [ProductController::class, 'brand'])->name('brand');
Route::get('/brands', [ProductController::class, 'brands'])->name('brands');
Route::get('/featured', [ProductController::class, 'featured'])->name('featured');
Route::get('/deals', [ProductController::class, 'deals'])->name('deals');
Route::get('/search', [ProductController::class, 'search'])->name('search');
Route::get('/product/{id}', [ProductController::class, 'show'])->name('product.show');

// Cart & Checkout
Route::get('/cart', function () {
    return view('cart');
})->name('cart');

Route::get('/checkout', function () {
    return view('checkout');
})->name('checkout');

// Informational Pages
Route::get('/about', function () {
    return view('about');
})->name('about');

Route::get('/contact', function () {
    return view('contact');
})->name('contact');

Route::get('/shipping', function () {
    return view('shipping');
})->name('shipping');

Route::get('/returns', function () {
    return view('returns');
})->name('returns');

Route::get('/faq', function () {
    return view('faq');
})->name('faq');
