<!-- Footer -->
<footer class="bg-gray-900 text-gray-300 mt-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-8">
            <!-- Brand Column -->
            <div class="lg:col-span-1">
                <a href="{{ url('/') }}" class="flex items-center gap-3 mb-4 group">
                    <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-500 rounded-xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                        </svg>
                    </div>
                    <span class="font-bold text-xl text-white">Beauty Bawl</span>
                </a>
                <p class="text-sm mb-4">
                    Premium beauty products for personal and family care. Trusted by thousands of happy customers.
                </p>
                
                <!-- Social Links -->
                <div class="flex gap-3">
                    <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-600 rounded-full flex items-center justify-center transition-colors" aria-label="Facebook">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-600 rounded-full flex items-center justify-center transition-colors" aria-label="Instagram">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                        </svg>
                    </a>
                    <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-600 rounded-full flex items-center justify-center transition-colors" aria-label="Twitter">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Shop Column -->
            <div>
                <h4 class="font-bold text-white mb-4">Shop</h4>
                <ul class="space-y-2 text-sm">
                    <li><a href="/category/skincare" class="hover:text-pink-400 transition-colors">Skincare</a></li>
                    <li><a href="/category/haircare" class="hover:text-pink-400 transition-colors">Haircare</a></li>
                    <li><a href="/category/makeup" class="hover:text-pink-400 transition-colors">Makeup</a></li>
                    <li><a href="/category/tools" class="hover:text-pink-400 transition-colors">Beauty Tools</a></li>
                    <li><a href="/deals" class="hover:text-pink-400 transition-colors">Special Deals</a></li>
                </ul>
            </div>

            <!-- Customer Service Column -->
            <div>
                <h4 class="font-bold text-white mb-4">Customer Service</h4>
                <ul class="space-y-2 text-sm">
                    <li><a href="{{ url('/about') }}" class="hover:text-pink-400 transition-colors">About Us</a></li>
                    <li><a href="{{ url('/contact') }}" class="hover:text-pink-400 transition-colors">Contact</a></li>
                    <li><a href="{{ url('/shipping') }}" class="hover:text-pink-400 transition-colors">Shipping Info</a></li>
                    <li><a href="{{ url('/returns') }}" class="hover:text-pink-400 transition-colors">Returns & Refunds</a></li>
                    <li><a href="{{ url('/faq') }}" class="hover:text-pink-400 transition-colors">FAQs</a></li>
                </ul>
            </div>

            <!-- Legal Column -->
            <div>
                <h4 class="font-bold text-white mb-4">Legal</h4>
                <ul class="space-y-2 text-sm">
                    <li><a href="/privacy" class="hover:text-pink-400 transition-colors">Privacy Policy</a></li>
                    <li><a href="/terms" class="hover:text-pink-400 transition-colors">Terms of Service</a></li>
                    <li><a href="/cookies" class="hover:text-pink-400 transition-colors">Cookie Policy</a></li>
                </ul>
                
                <div class="mt-6 pt-6 border-t border-gray-800">
                    <h4 class="font-bold text-white mb-3">Payment Methods</h4>
                    <div class="flex gap-2 flex-wrap">
                        <div class="px-3 py-1 bg-gray-800 rounded text-xs font-medium">Stripe</div>
                        <div class="px-3 py-1 bg-gray-800 rounded text-xs font-medium">M-Pesa</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="pt-8 border-t border-gray-800 flex flex-col md:flex-row justify-between items-center gap-4">
            <p class="text-sm text-gray-500">
                © {{ date('Y') }} Beauty Bawl. All rights reserved.
            </p>
            <div class="flex items-center gap-2 text-sm text-gray-500">
                <svg class="w-5 h-5 text-pink-500" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 17.657l-6.828-6.829a4 4 0 010-5.656z" clip-rule="evenodd" />
                </svg>
                <span>Made with love for beautiful families</span>
            </div>
        </div>
    </div>
</footer>
