<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Our Brands - Beauty Bawl</title>
        <meta name="description" content="Explore all beauty brands available at Beauty Bawl. Shop trusted and premium beauty brands." />
        
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="antialiased font-sans bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:from-gray-900 dark:via-gray-900 dark:to-gray-800 min-h-screen">
        @include('partials.header')

        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <!-- Breadcrumb -->
            <nav class="flex mb-8 text-sm" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-2">
                    <li><a href="/" class="text-gray-500 hover:text-pink-600">Home</a></li>
                    <li><span class="text-gray-400">/</span></li>
                    <li class="text-gray-900 dark:text-gray-100 font-medium">Brands</li>
                </ol>
            </nav>

            <!-- Page Header -->
            <div class="text-center mb-12">
                <h1 class="text-5xl font-bold mb-4 bg-gradient-to-r from-pink-600 to-purple-600 bg-clip-text text-transparent">Our Brands</h1>
                <p class="text-xl text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">Explore premium beauty brands trusted by millions worldwide</p>
            </div>

            <!-- Brands Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-12">
                @php
                    $brands = [
                        ['name' => 'CeraVe', 'slug' => 'cerave', 'products' => 45, 'description' => 'Dermatologist-recommended skincare developed with ceramides'],
                        ['name' => 'L\'Oréal', 'slug' => 'loreal', 'products' => 78, 'description' => 'World\'s leading beauty brand with innovative products'],
                        ['name' => 'Neutrogena', 'slug' => 'neutrogena', 'products' => 52, 'description' => 'Dermatologist-tested and clinically proven formulas'],
                        ['name' => 'Maybelline', 'slug' => 'maybelline', 'products' => 63, 'description' => 'Professional makeup products for everyone'],
                        ['name' => 'Nivea', 'slug' => 'nivea', 'products' => 41, 'description' => 'Trusted skincare solutions for the whole family'],
                        ['name' => 'Garnier', 'slug' => 'garnier', 'products' => 55, 'description' => 'Natural beauty products with proven effectiveness'],
                        ['name' => 'Olay', 'slug' => 'olay', 'products' => 38, 'description' => 'Anti-aging and skincare innovations'],
                        ['name' => 'Dove', 'slug' => 'dove', 'products' => 47, 'description' => 'Real beauty products for real skin'],
                        ['name' => 'The Ordinary', 'slug' => 'the-ordinary', 'products' => 32, 'description' => 'Clinical formulations with integrity'],
                    ];
                @endphp

                @foreach ($brands as $brand)
                    <a href="{{ route('brand', $brand['slug']) }}" class="group bg-white dark:bg-gray-800 rounded-2xl shadow-lg hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300 overflow-hidden">
                        <div class="p-8">
                            <!-- Brand Logo Placeholder -->
                            <div class="w-20 h-20 bg-gradient-to-br from-pink-500 to-purple-500 rounded-xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform">
                                <span class="text-3xl font-bold text-white">{{ substr($brand['name'], 0, 1) }}</span>
                            </div>

                            <!-- Brand Name -->
                            <h2 class="text-2xl font-bold mb-2 text-gray-900 dark:text-white">{{ $brand['name'] }}</h2>
                            
                            <!-- Product Count -->
                            <p class="text-sm font-medium text-pink-600 dark:text-pink-400 mb-3">{{ $brand['products'] }} Products</p>
                            
                            <!-- Description -->
                            <p class="text-gray-600 dark:text-gray-400 mb-4">{{ $brand['description'] }}</p>
                            
                            <!-- Shop Button -->
                            <div class="flex items-center text-pink-600 dark:text-pink-400 font-semibold group-hover:gap-3 gap-2 transition-all">
                                <span>Shop Now</span>
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>

            <!-- Featured Banner -->
            <div class="bg-gradient-to-r from-pink-600 to-purple-600 rounded-3xl p-12 text-center text-white shadow-2xl">
                <h2 class="text-3xl font-bold mb-4">Can't Find Your Favorite Brand?</h2>
                <p class="text-lg mb-6 opacity-90">We're constantly adding new brands to our collection. Let us know what you'd like to see!</p>
                <a href="{{ route('contact') }}" class="inline-flex items-center gap-2 px-8 py-4 bg-white text-pink-600 font-semibold rounded-full shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all">
                    <span>Request a Brand</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                    </svg>
                </a>
            </div>
        </main>

        @include('partials.footer')
    </body>
</html>
