<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>About Us - Beauty Bawl</title>
        
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:bg-gradient-to-br dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 text-gray-900 dark:text-gray-100 antialiased">
        
        @include('partials.header')

        <main class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <!-- Hero Section -->
            <div class="text-center mb-16">
                <h1 class="text-5xl font-bold mb-6">About Beauty Bawl</h1>
                <p class="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
                    Curating premium beauty products for families who care about quality, safety, and results
                </p>
            </div>

            <!-- Story Section -->
            <div class="bg-white dark:bg-gray-800 rounded-3xl shadow-xl p-8 md:p-12 mb-12">
                <h2 class="text-3xl font-bold mb-6">Our Story</h2>
                <div class="space-y-4 text-gray-600 dark:text-gray-300 leading-relaxed">
                    <p>
                        Beauty Bawl was born from a simple belief: every family deserves access to premium, safe, and effective beauty products without compromise. Founded in 2024, we set out to create a marketplace that bridges the gap between professional-grade beauty solutions and family-friendly formulations.
                    </p>
                    <p>
                        Our journey began when our founders, parents themselves, struggled to find beauty products that were both effective and gentle enough for the whole family. From skincare to haircare, makeup to professional tools, we carefully curate every product in our collection.
                    </p>
                    <p>
                        Today, we're proud to serve thousands of families, helping them discover products they can trust and love.
                    </p>
                </div>
            </div>

            <!-- Values Grid -->
            <div class="grid md:grid-cols-3 gap-8 mb-12">
                <div class="bg-gradient-to-br from-pink-100 to-pink-200 dark:from-pink-900/30 dark:to-pink-800/30 rounded-2xl p-8 text-center">
                    <div class="w-16 h-16 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-8 h-8 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Family Safe</h3>
                    <p class="text-gray-600 dark:text-gray-400">Every product is carefully vetted for safety and tested for family use</p>
                </div>

                <div class="bg-gradient-to-br from-purple-100 to-purple-200 dark:from-purple-900/30 dark:to-purple-800/30 rounded-2xl p-8 text-center">
                    <div class="w-16 h-16 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Premium Quality</h3>
                    <p class="text-gray-600 dark:text-gray-400">Professional-grade products that deliver real, visible results</p>
                </div>

                <div class="bg-gradient-to-br from-green-100 to-green-200 dark:from-green-900/30 dark:to-green-800/30 rounded-2xl p-8 text-center">
                    <div class="w-16 h-16 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Eco-Conscious</h3>
                    <p class="text-gray-600 dark:text-gray-400">Sustainable sourcing and eco-friendly packaging whenever possible</p>
                </div>
            </div>

            <!-- Team Section -->
            <div class="bg-white dark:bg-gray-800 rounded-3xl shadow-xl p-8 md:p-12 mb-12">
                <h2 class="text-3xl font-bold mb-8 text-center">Our Commitment</h2>
                <div class="grid md:grid-cols-2 gap-8">
                    <div class="flex gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-pink-100 dark:bg-pink-900/30 rounded-xl flex items-center justify-center">
                                <svg class="w-6 h-6 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="font-bold mb-2">Curated Selection</h3>
                            <p class="text-gray-600 dark:text-gray-400">We personally test and review every product before it reaches our store</p>
                        </div>
                    </div>

                    <div class="flex gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-purple-100 dark:bg-purple-900/30 rounded-xl flex items-center justify-center">
                                <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                </svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="font-bold mb-2">Fast Shipping</h3>
                            <p class="text-gray-600 dark:text-gray-400">Quick delivery so you can start your beauty journey without delay</p>
                        </div>
                    </div>

                    <div class="flex gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-blue-100 dark:bg-blue-900/30 rounded-xl flex items-center justify-center">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                </svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="font-bold mb-2">Secure Payments</h3>
                            <p class="text-gray-600 dark:text-gray-400">Safe checkout with Stripe and M-Pesa integration</p>
                        </div>
                    </div>

                    <div class="flex gap-4">
                        <div class="flex-shrink-0">
                            <div class="w-12 h-12 bg-green-100 dark:bg-green-900/30 rounded-xl flex items-center justify-center">
                                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                </svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="font-bold mb-2">Customer Care</h3>
                            <p class="text-gray-600 dark:text-gray-400">Dedicated support team ready to help with any questions</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- CTA Section -->
            <div class="bg-gradient-to-r from-pink-600 via-purple-600 to-indigo-600 rounded-3xl p-12 text-center text-white shadow-2xl">
                <h2 class="text-3xl font-bold mb-4">Join Our Beauty Community</h2>
                <p class="text-lg mb-8 text-white/90">Start your journey to beautiful, healthy skin and hair today</p>
                <a href="{{ url('/shop') }}" class="inline-flex items-center gap-2 px-8 py-4 bg-white text-pink-600 rounded-full font-bold shadow-xl hover:scale-105 transform transition-all">
                    <span>Shop Now</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                    </svg>
                </a>
            </div>
        </main>

        @include('partials.footer')
    </body>
</html>
