<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PaymentsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = DB::table('users')->pluck('user_id')->toArray();
        
        if (empty($users)) {
            $this->command->warn('No users found. Please run UsersSeeder first.');
            return;
        }

        $payments = [];
        
        // Create 20 sample payments over the past month
        for ($i = 0; $i < 20; $i++) {
            $paymentDate = now()->subDays(rand(0, 30));
            
            $payments[] = [
                'user_id' => $users[array_rand($users)],
                'amount' => rand(5000, 150000),
                'payment_date' => $paymentDate->format('Y-m-d'),
                'description' => $this->generateDescription(),
                'created_at' => $paymentDate,
                'updated_at' => $paymentDate,
            ];
        }

        foreach ($payments as $payment) {
            DB::table('payments')->insert($payment);
        }
        
        $this->command->info('Successfully seeded ' . count($payments) . ' payments.');
    }
    
    private function generateDescription(): string
    {
        $descriptions = [
            'Payment received from client for services',
            'Payment to supplier for inventory purchase',
            'Customer refund for returned items',
            'Staff commission payout',
            'Advance payment for service booking',
            'Final payment for completed service',
            'Deposit for product pre-order',
            'Vendor payment for supplies',
            'Utility bill payment',
            'Rent payment',
            'Miscellaneous payment',
            'Service payment - cash',
            'Product sale payment',
            'Consultation fee payment',
        ];
        
        return $descriptions[array_rand($descriptions)];
    }
}
