<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_items', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('sku')->unique();
            $table->text('description')->nullable();
            $table->string('category')->nullable();
            $table->string('unit')->default('piece'); // piece, kg, liter, box, etc.
            $table->foreignId('supplier_id')->nullable()->constrained('suppliers')->onDelete('set null');

            // Stock Information
            $table->decimal('quantity', 10, 2)->default(0);
            $table->decimal('reorder_level', 10, 2)->default(10);
            $table->decimal('minimum_stock', 10, 2)->default(5);
            $table->decimal('maximum_stock', 10, 2)->nullable();

            // Pricing
            $table->decimal('buying_price', 10, 2);
            $table->decimal('selling_price', 10, 2);
            $table->decimal('markup_percentage', 5, 2)->nullable();

            // Additional Info
            $table->string('barcode')->nullable()->unique();
            $table->string('location')->nullable(); // warehouse location
            $table->date('expiry_date')->nullable();
            $table->string('image_url')->nullable();

            // Status
            $table->enum('status', ['active', 'inactive', 'discontinued'])->default('active');

            // Tracking
            $table->decimal('total_sold', 10, 2)->default(0);
            $table->decimal('total_revenue', 12, 2)->default(0);
            $table->timestamp('last_restocked_at')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_items');
    }
};
