<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table): void {
            $table->increments('expense_id');
            $table->integer('admin_id');
            $table->date('expense_date')->default(DB::raw('CURRENT_DATE'));
            $table->decimal('amount', 10, 2);
            $table->text('description')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();

            $table->index('admin_id', 'idx_expenses_admin');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
