<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('commissions', function (Blueprint $table): void {
            $table->increments('commission_id');
            $table->integer('user_id');
            $table->integer('completions_id');
            $table->decimal('commission_amount', 10, 2);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();

            $table->index('user_id', 'fk_commissions_user');
            $table->index('completions_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('commissions');
    }
};
