<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Signin extends Model
{
    use HasFactory;

    protected $primaryKey = 'signin_id';

    protected $fillable = [
        'user_id',
        'status',
        'approved',
        'latitude',
        'longitude',
        'location_address',
    ];

    protected function casts(): array
    {
        return [
            'status' => 'boolean',
            'approved' => 'boolean',
            'latitude' => 'decimal:8',
            'longitude' => 'decimal:8',
            'created_at' => 'datetime',
            'updated_at' => 'datetime',
        ];
    }

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }
}
